///////////////////////////////////////////////////////////////////////////////////
// Main wdl file for neomill infinite terrain project
////////////////////////////////////////////////////////////////////////////
// The PATH keyword gives directories where game files can be found,
// relative to the level directory

Path "Template";	// Path to WDL templates subdirectory, code wdl !!!
//path "Code_wdl";	// Path to A6 templates directory
//SAVEDIR "D:\\A7\\Neomill7";// not in use here
////////////////////////////////////////////////////////////////////////////
// The INCLUDE keyword can be used to include further WDL files,
// like those in the TEMPLATE subdirectory, with prefabricated actions

include <movement.wdl>;//Has been changed for neomill mdl-repositioning !!!
include <messages.wdl>;
include <particle.wdl>; // remove when you need no particles
include <doors.wdl>;
include <actors.wdl>;   // remove when you need no actors
include <weapons.wdl>;  // remove when you need no weapons
include <war.wdl>;      // remove when you need no fighting
include <menu.wdl>;
include <Mill_Control7.wdl>;// Heart of neomill7 treadmill
include <Neomillpos7.wdl>;// for positioning surface stuff in neomill worlds
//you want to add surface entities
////////////////////////////////////////////////////////////////////////////
// variable redefinitions
var video_mode = 8;	 // screen size 1024x768
var video_depth = 32; // 32 bit colour D3D mode
var warn_level = 2;
//var Video_screen = 1;
var terrain_chunk = 0;
 
/////////////////////////////////////////////////////////////////
// define a splash screen with the required A4/A5 logo
bmap splashmap = <logolite.pcx>; // the default logo in templates
panel splashscreen { bmap = splashmap; flags = refresh,d3d; }

/////////////////////////////////////////////////////////////////
// The main() function is started at game start



var menu_pos[2] = 10, 10;	// position of menu on screen


//var vmod = 7;



string warlock_mdl = <warlock.mdl>;
string shell_wmb = <Neomill.wmb>;
//bmap mountains = <mount16.pcx>;
bmap mountains = <mountain.tga>;




function main()
{
// center the splash screen for non-640x480 resolutions
	splashscreen.pos_x = (screen_size.x - bmap_width(splashmap))/2;
	splashscreen.pos_y = (screen_size.y - bmap_height(splashmap))/2;
// set it visible
	splashscreen.visible = on;
// wait 3 frames (triple buffering) until it is rendered and flipped to the foreground
	wait(3);
// now load the level
	level_load(shell_wmb);
// wait the required second, then switch the splashscreen off.
	sleep(1);
  	splashscreen.visible = off;

// load some global variables, like sound volume
	load_status();

// set some global values for the test level, like the walking
// animation width
	movement_scale = 0.5;
	anim_walk_dist = 2; // for the new guards
	anim_run_dist = 3;
	walk_or_run = 12;
	camera_dist.Z = -65;
	var clip_range = 1000;
	Clip_factor= 1;
	slopefac = 0.5;	// prevent shaking in ravines
	sky_clip = 25;
	fog_color=1;
	sky_color.red = 250;
	sky_color.green = 250;
	sky_color.blue = 250; // hellblauer Himmel  
	camera.fog_start = 3 * Clip_range;	// Nebel startet bei 86% von clip_ranges
   camera.fog_end = 5.0 * clip_range;	// Nebel endet bei 90% von clip_ranges 
   camera.clip_far = 4500;    
// call further functions here...


Startmill ();// Load 9 Tiles first to start the mill 
create ();// Main Action of Millcontrol7, the heart of Neomill7

}











